# Images Directory

This directory contains all the images used in the APT Infotech website for local development.

## Directory Structure

```
public/images/
├── logos/
│   ├── apt-logo.png
│   └── apt-logo-white.png
├── hero/
│   ├── hero-illustration.png
│   └── cta-illustration.png
├── services/
│   ├── ecommerce-hero.jpg
│   ├── ecommerce-service.jpg
│   ├── restaurant-hero.jpg
│   ├── restaurant-service.jpg
│   ├── inventory-hero.jpg
│   ├── inventory-service.jpg
│   ├── billing-hero.jpg
│   ├── billing-service.jpg
│   ├── crm-hero.jpg
│   ├── crm-service.jpg
│   ├── erp-hero.jpg
│   ├── erp-service.jpg
│   ├── matrimonial-hero.jpg
│   ├── matrimonial-service.jpg
│   ├── realestate-hero.jpg
│   ├── realestate-service.jpg
│   ├── custom-website-hero.jpg
│   ├── custom-website-service.jpg
│   ├── mobile-app-hero.jpg
│   └── mobile-app-service.jpg
├── portfolio/
│   ├── portfolio-freshcart.jpg
│   ├── portfolio-spice-route.jpg
│   ├── portfolio-manufacture-erp.jpg
│   ├── portfolio-fittracker.jpg
│   ├── portfolio-kerala-tourism.jpg
│   ├── portfolio-medstore.jpg
│   ├── portfolio-edumanage.jpg
│   └── portfolio-propertyhub.jpg
├── team/
│   ├── team-ceo.jpg
│   ├── team-cto.jpg
│   ├── team-dev-head.jpg
│   └── team-design-head.jpg
└── about/
    └── about-mission.jpg
```

## Usage

In your React components, reference these images using `/images/` path:

```jsx
// Example usage
<img src="/images/logos/apt-logo.png" alt="APT Infotech Logo" />
<img src="/images/hero/hero-illustration.png" alt="Hero Image" />
<img src="/images/services/ecommerce-hero.jpg" alt="E-commerce Service" />
```

## Notes

- All images in the `public` folder are served statically
- Use absolute paths starting with `/images/`
- Optimize images for web before adding them here
- Recommended formats: PNG for logos, JPG for photos, WebP for better compression